import 'package:flutter/material.dart';
import '../clx_verification_code.dart';
import '../widgets/tips_widget/status_tips_widget.dart';

class CLXLineCodeManageView extends StatelessWidget {
  const CLXLineCodeManageView({
    super.key,
    required this.viewModel,
    required this.config,
    this.disabled = false,
  });

  /// 页面状态变化处理控制器
  final VerificationCodeViewModel viewModel;

  /// 是否禁用
  final bool disabled;

  /// 样式配置
  final LineCodeManageConfig config;

  @override
  Widget build(BuildContext context) {
    return AnimatedBuilder(
      animation: viewModel,
      builder: (context, child) {
        return Container(
          margin: config.margin,
          padding: config.padding,
          decoration: config.decoration,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Expanded(
                    child: TextField(
                      controller: viewModel.codeInputCtrl,
                      keyboardType: TextInputType.number,
                      maxLength: viewModel.maxLength,
                      style: config.style,
                      enabled: !disabled,
                      enableInteractiveSelection: false,
                      decoration: InputDecoration(
                        isCollapsed: config.isCollapsed,
                        counterText: '',
                        hintText: config.hintText,
                        hintStyle: config.hintStyle,
                        border: InputBorder.none,
                      ),
                    ),
                  ),
                  const SizedBox(width: 10),
                  Visibility(
                    visible: viewModel.codeSendBtn.isNotEmpty,
                    child: GestureDetector(
                      onTap: viewModel.sendSmsCode,
                      child: Text(
                        viewModel.codeSendBtn,
                        style: viewModel.codeSendType.isUnSend
                            ? config.countdownStyle
                            : config.codeSendStyle,
                      ),
                    ),
                  ),
                ],
              ),
              Visibility(
                visible: viewModel.verifyCodeError.isNotEmpty,
                child: Column(
                  children: [
                    const SizedBox(height: 5),
                    Text(
                      viewModel.verifyCodeError,
                      style: config.errorStyle,
                    ),
                  ],
                ),
              ),
              Visibility(
                visible: viewModel.isShowTip,
                child: StatusTipsWidget(
                  codeSendType: viewModel.codeSendType,
                  isAccessOutbound: viewModel.isAccessOutbound,
                  onSendSms: viewModel.sendSmsCode,
                  onSendVoice: viewModel.sendVoiceCode,
                  onContactService: viewModel.contactService,
                  tipsStyle: config.tipsStyle,
                  reSendStyle: config.reSendStyle,
                  voiceSendStyle: config.voiceSendStyle,
                  contactStyle: config.contactStyle,
                  isSmallWindow: config.isSmallWindow,
                ),
              ),
            ],
          ),
        );
      },
    );
  }
}
