
/// 验证码服务接口
abstract class IVerificationService {
  /// 获取短信验证码
  /// 返回 true 表示发送成功，false 表示失败
  Future<bool> sendSmsCode();

  /// 获取语音验证码
  /// 返回 true 表示发送成功，false 表示失败
  Future<bool> sendVoiceCode();

  /// 校验验证码
  /// 返回 null 表示校验通过，否则返回错误信息
  Future<String?> verifyCode(String code);

  /// 联系客服
  Future<void> contactCustomerService();
}
