import 'dart:async';
import 'package:flutter/foundation.dart';

/// 倒计时控制器
class CountdownController extends ChangeNotifier {
  CountdownController({this.duration = 60});

  final int duration;
  Timer? _timer;
  int _currentCount = 0;
  bool _isRunning = false;

  int get currentCount => _currentCount;
  bool get isRunning => _isRunning;

  /// 开始倒计时
  void start() {
    if (_isRunning) return;
    
    _currentCount = duration;
    _isRunning = true;
    notifyListeners();

    _timer?.cancel();
    _timer = Timer.periodic(const Duration(seconds: 1), (timer) {
      if (_currentCount <= 0) {
        stop();
      } else {
        _currentCount--;
        notifyListeners();
      }
    });
  }

  /// 停止倒计时
  void stop() {
    _timer?.cancel();
    _timer = null;
    _isRunning = false;
    _currentCount = duration; // 重置为初始值
    notifyListeners();
  }

  @override
  void dispose() {
    _timer?.cancel();
    super.dispose();
  }
}
