//
//  ClxMapNavigationConvertUtil.h
//  clx_map_navigation
//
//  Created by yjc on 2022/11/30.
//

#import <Foundation/Foundation.h>
#import <Flutter/Flutter.h>
#include <AMapNaviKit/MAMapKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface ClxMapNavigationConvertUtil : NSObject

/// 从数据中解析经纬度
/// @param array 经纬度数组对（默认第一个当做维度，第二个当做经度）
+ (CLLocationCoordinate2D)coordinateFromArray:(NSArray *)array;

/// 解析得到mapRect结构
/// @param array json数组[southwest,northeast]，分别为西南、东北的坐标
+ (MAMapRect)mapRectFromArray:(NSArray *)array;

@end

NS_ASSUME_NONNULL_END
