package com.clx.navigation.clx_map_navigation

import android.content.Context
import android.util.Log
import io.flutter.plugin.common.BinaryMessenger
import com.clx.navigation.clx_map_navigation.LifecycleProvider
import io.flutter.plugin.platform.PlatformViewFactory
import io.flutter.plugin.common.StandardMessageCodec
import io.flutter.plugin.platform.PlatformView
import com.clx.navigation.clx_map_navigation.NavigationPlatformViewFactory
import com.clx.navigation.clx_map_navigation.NavigationPlatformView

/**
 * @author whm
 * @date 2020/10/27 4:08 PM
 * @mail hongming.whm@alibaba-inc.com
 * @since
 */
internal class NavigationPlatformViewFactory(
    private val messenger: BinaryMessenger,
    private val lifecycleProvider: LifecycleProvider
) : PlatformViewFactory(StandardMessageCodec.INSTANCE) {
    override fun create(context: Context, viewId: Int, args: Any?): PlatformView {
        Log.d(Constants.TAG, "create: ")
        return NavigationPlatformView(
            context,
            messenger,
            viewId,
            args,
            lifecycleProvider
        )
    }

}