package com.clx.navigation.clx_map_navigation

import android.content.Context
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.lifecycle.DefaultLifecycleObserver
import androidx.lifecycle.LifecycleOwner
import com.amap.api.navi.*
import com.amap.api.navi.enums.NaviType
import com.amap.api.navi.enums.PathPlanningStrategy
import com.amap.api.navi.model.*
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding.OnSaveInstanceStateListener
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel
import io.flutter.plugin.common.MethodChannel.MethodCallHandler
import io.flutter.plugin.platform.PlatformView

/**
 * @author whm
 * @date 2020/10/27 5:49 PM
 * @mail hongming.whm@alibaba-inc.com
 * @since
 */
class NavigationPlatformView internal constructor(
    private val context: Context,
    messenger: BinaryMessenger,
    viewId: Int,
    args: Any?,
    lifecycleProvider: LifecycleProvider?,
) : DefaultLifecycleObserver,
    OnSaveInstanceStateListener, MethodCallHandler, PlatformView, AMapNaviListener,
    AMapNaviViewListener {

    private var mAMapNaviView: AMapNaviView? = null
    private var disposed = false
    private var methodChannel: MethodChannel
    private var aMapNavi: AMapNavi? = null

    init {
        Log.d(Constants.TAG, "init: viewId = $viewId args = $args")
        val map = args as Map<*, *>?
        val startPoint = (map?.get("startPoint") ?: hashMapOf<Any, Any>()) as Map<*, *>
        val endPoint = (map?.get("endPoint") ?: hashMapOf<Any, Any>()) as Map<*, *>
        val startLat = (startPoint["latitude"] ?: 0.0) as Double
        val startLng = (startPoint["longitude"] ?: 0.0) as Double
        val endLat = (endPoint["latitude"] ?: 0.0) as Double
        val endLng = (endPoint["longitude"] ?: 0.0) as Double
        Log.d(
            Constants.TAG, "init: startLat = $startLat startLng = $startLng" +
                    " endLat = $endLat endLng = $endLng"
        )
        // 同意隐私权限
        NaviSetting.updatePrivacyShow(context.applicationContext, true, true)
        NaviSetting.updatePrivacyAgree(context.applicationContext, true)
        // 方法通道
        methodChannel = MethodChannel(messenger, Constants.VIEW_TYPE)
        methodChannel.setMethodCallHandler(this)
        // 导航view
        try {
            mAMapNaviView = AMapNaviView(context)
            mAMapNaviView?.setAMapNaviViewListener(this)
            lifecycleProvider?.lifecycle?.addObserver(this)
            // 获取导航Manager
            aMapNavi = AMapNavi.getInstance(context)
            aMapNavi?.addAMapNaviListener(this)
            // 设置语音播报
            aMapNavi?.setUseInnerVoice(true, false)
            aMapNavi?.startSpeak()
            // 起点信息
            val startList: MutableList<NaviLatLng> = ArrayList()
            startList.add(NaviLatLng(startLat, startLng))
            // 终点信息
            val endList: MutableList<NaviLatLng> = ArrayList()
            endList.add(NaviLatLng(endLat, endLng))
            // 经纬度算路
            aMapNavi?.calculateDriveRoute(
                startList,
                endList,
                null,
                PathPlanningStrategy.DRIVING_MULTIPLE_ROUTES_DEFAULT
            )

        } catch (e: Throwable) {
            Log.d(Constants.TAG, "<init>", e)
        }
    }

    override fun onMethodCall(call: MethodCall, result: MethodChannel.Result) {
        Log.d(Constants.TAG, "onMethodCall: method = ${call.method} arguments = ${call.arguments}")
        when (call.method) {
            "navigation#startNav" -> {
                val arguments = call.arguments as Map<*, *>?
                val startPoint = (arguments?.get("startPoint") ?: hashMapOf<Any, Any>()) as Map<*, *>
                val endPoint = (arguments?.get("endPoint") ?: hashMapOf<Any, Any>()) as Map<*, *>
                val startLat = (startPoint["latitude"] ?: 0.0) as Double
                val startLng = (startPoint["longitude"] ?: 0.0) as Double
                val endLat = (endPoint["latitude"] ?: 0.0) as Double
                val endLng = (endPoint["longitude"] ?: 0.0) as Double
                // 起点信息
                val startList: MutableList<NaviLatLng> = ArrayList()
                startList.add(NaviLatLng(startLat, startLng))
                // 终点信息
                val endList: MutableList<NaviLatLng> = ArrayList()
                endList.add(NaviLatLng(endLat, endLng))
                startNav(startList, endList)
            }
            else -> result.notImplemented()
        }

    }

    private fun startNav(startList: MutableList<NaviLatLng>, endList: MutableList<NaviLatLng>) {
        aMapNavi?.calculateDriveRoute(
            startList,
            endList,
            null,
            PathPlanningStrategy.DRIVING_MULTIPLE_ROUTES_DEFAULT
        )
    }

    override fun onCreate(owner: LifecycleOwner) {
        Log.d(Constants.TAG, "onCreate==>")
        try {
            if (disposed) {
                return
            }
            if (null != mAMapNaviView) {
                mAMapNaviView?.onCreate(null)
            }
        } catch (e: Throwable) {
            Log.d(Constants.TAG, "onCreate", e)
        }
    }

    override fun onStart(owner: LifecycleOwner) {
        Log.d(Constants.TAG, "onStart==>")
    }

    override fun onResume(owner: LifecycleOwner) {
        Log.d(Constants.TAG, "onResume==>")
        try {
            if (disposed) {
                return
            }
            if (null != mAMapNaviView) {
                mAMapNaviView?.onResume()
            }
        } catch (e: Throwable) {
            Log.d(Constants.TAG, "onResume", e)
        }
    }

    override fun onPause(owner: LifecycleOwner) {
        Log.d(Constants.TAG, "onPause==>")
        try {
            if (disposed) {
                return
            }
            mAMapNaviView?.onPause()
        } catch (e: Throwable) {
            Log.d(Constants.TAG, "onPause", e)
        }
    }

    override fun onStop(owner: LifecycleOwner) {
        Log.d(Constants.TAG, "onStop==>")
    }

    override fun onDestroy(owner: LifecycleOwner) {
        Log.d(Constants.TAG, "onDestroy==>")
        try {
            if (disposed) {
                return
            }
            destroyMapViewIfNecessary()
        } catch (e: Throwable) {
            Log.d(Constants.TAG, "onDestroy", e)
        }
    }

    override fun onSaveInstanceState(bundle: Bundle) {
        Log.d(Constants.TAG, "onDestroy==>")
        try {
            if (disposed) {
                return
            }
            mAMapNaviView?.onSaveInstanceState(bundle)
        } catch (e: Throwable) {
            Log.d(Constants.TAG, "onSaveInstanceState", e)
        }
    }

    override fun onRestoreInstanceState(bundle: Bundle?) {
        Log.d(Constants.TAG, "onDestroy==>")
        try {
            if (disposed) {
                return
            }
            mAMapNaviView?.onCreate(bundle)
        } catch (e: Throwable) {
            Log.d(Constants.TAG, "onRestoreInstanceState", e)
        }
    }

    override fun getView(): View? {
        Log.d(Constants.TAG, "getView: ")
        return mAMapNaviView
    }

    override fun dispose() {
        Log.d(Constants.TAG, "dispose==>")
        try {
            if (disposed) {
                return
            }
            methodChannel.setMethodCallHandler(null)
            destroyMapViewIfNecessary()
            disposed = true
        } catch (e: Throwable) {
            Log.d(Constants.TAG, "dispose", e)
        }
    }

    private fun destroyMapViewIfNecessary() {
        if (mAMapNaviView == null) {
            return
        }
        // 停止播报语音
        AMapNavi.getInstance(context).stopSpeak()
        AMapNavi.getInstance(context).stopNavi()
        mAMapNaviView?.onDestroy()
    }

    /**===========================AMapNaviListener================================*/

    override fun onCalculateRouteSuccess(p0: AMapCalcRouteResult?) {
        Log.d(Constants.TAG, "onCalculateRouteSuccess: ")
        // 开启导航
        AMapNavi.getInstance(context).startNavi(NaviType.GPS)
    }

    override fun onInitNaviFailure() {
        Log.d(Constants.TAG, "onInitNaviFailure: ")
    }

    override fun onInitNaviSuccess() {
        Log.d(Constants.TAG, "onInitNaviSuccess: ")
    }

    override fun onStartNavi(p0: Int) {
        Log.d(Constants.TAG, "onStartNavi: ")
    }

    override fun onTrafficStatusUpdate() {
        Log.d(Constants.TAG, "onTrafficStatusUpdate: ")
    }

    override fun onLocationChange(p0: AMapNaviLocation?) {
        Log.d(Constants.TAG, "onLocationChange: ")
    }

    override fun onGetNavigationText(p0: Int, p1: String?) {
        Log.d(Constants.TAG, "onGetNavigationText: ")
    }

    override fun onGetNavigationText(p0: String?) {
        Log.d(Constants.TAG, "onGetNavigationText: ")
    }

    override fun onEndEmulatorNavi() {
        Log.d(Constants.TAG, "onEndEmulatorNavi: ")
    }

    override fun onArriveDestination() {
        Log.d(Constants.TAG, "onArriveDestination: ")
    }

    override fun onCalculateRouteFailure(p0: Int) {
        Log.d(Constants.TAG, "onCalculateRouteFailure: ")
    }

    override fun onCalculateRouteFailure(p0: AMapCalcRouteResult?) {
        Log.d(Constants.TAG, "onCalculateRouteFailure: ")
    }

    override fun onReCalculateRouteForYaw() {
        Log.d(Constants.TAG, "onReCalculateRouteForYaw: ")
    }

    override fun onReCalculateRouteForTrafficJam() {
        Log.d(Constants.TAG, "onReCalculateRouteForTrafficJam: ")
    }

    override fun onArrivedWayPoint(p0: Int) {
        Log.d(Constants.TAG, "onArrivedWayPoint: ")
    }

    override fun onGpsOpenStatus(p0: Boolean) {
        Log.d(Constants.TAG, "onGpsOpenStatus: ")
    }

    override fun onNaviInfoUpdate(p0: NaviInfo?) {
        Log.d(Constants.TAG, "onNaviInfoUpdate: ")
    }

    override fun updateCameraInfo(p0: Array<out AMapNaviCameraInfo>?) {
        Log.d(Constants.TAG, "updateCameraInfo: ")
    }

    override fun updateIntervalCameraInfo(
        p0: AMapNaviCameraInfo?,
        p1: AMapNaviCameraInfo?,
        p2: Int,
    ) {
        Log.d(Constants.TAG, "updateIntervalCameraInfo: ")
    }

    override fun onServiceAreaUpdate(p0: Array<out AMapServiceAreaInfo>?) {
        Log.d(Constants.TAG, "onServiceAreaUpdate: ")
    }

    override fun showCross(p0: AMapNaviCross?) {
        Log.d(Constants.TAG, "showCross: ")
    }

    override fun hideCross() {
        Log.d(Constants.TAG, "hideCross: ")
    }

    override fun showModeCross(p0: AMapModelCross?) {
        Log.d(Constants.TAG, "showModeCross: ")
    }

    override fun hideModeCross() {
        Log.d(Constants.TAG, "hideModeCross: ")
    }

    override fun showLaneInfo(p0: Array<out AMapLaneInfo>?, p1: ByteArray?, p2: ByteArray?) {
        Log.d(Constants.TAG, "showLaneInfo: ")
    }

    override fun showLaneInfo(p0: AMapLaneInfo?) {
        Log.d(Constants.TAG, "showLaneInfo: ")
    }

    override fun hideLaneInfo() {
        Log.d(Constants.TAG, "hideLaneInfo: ")
    }

    override fun onCalculateRouteSuccess(p0: IntArray?) {
        Log.d(Constants.TAG, "onCalculateRouteSuccess: ")
    }

    override fun notifyParallelRoad(p0: Int) {
        Log.d(Constants.TAG, "notifyParallelRoad: ")
    }

    override fun OnUpdateTrafficFacility(p0: Array<out AMapNaviTrafficFacilityInfo>?) {
        Log.d(Constants.TAG, "OnUpdateTrafficFacility: ")
    }

    override fun OnUpdateTrafficFacility(p0: AMapNaviTrafficFacilityInfo?) {
        Log.d(Constants.TAG, "OnUpdateTrafficFacility: ")
    }

    override fun updateAimlessModeStatistics(p0: AimLessModeStat?) {
        Log.d(Constants.TAG, "updateAimlessModeStatistics: ")
    }

    override fun updateAimlessModeCongestionInfo(p0: AimLessModeCongestionInfo?) {
        Log.d(Constants.TAG, "updateAimlessModeCongestionInfo: ")
    }

    override fun onPlayRing(p0: Int) {
        Log.d(Constants.TAG, "onPlayRing: ")
    }

    override fun onNaviRouteNotify(p0: AMapNaviRouteNotifyData?) {
        Log.d(Constants.TAG, "onNaviRouteNotify: ")
    }

    override fun onGpsSignalWeak(p0: Boolean) {
        Log.d(Constants.TAG, "onGpsSignalWeak: ")
    }

    /**=======================AMapNaviViewListener=======================*/

    override fun onNaviCancel() {
        Log.d(Constants.TAG, "onNaviCancel: ")
        // 退出导航
        methodChannel.invokeMethod("navigationClosed", "")
    }

    override fun onNaviBackClick(): Boolean {
        Log.d(Constants.TAG, "onNaviBackClick: ")
        return false
    }

    override fun onNaviSetting() {
        Log.d(Constants.TAG, "onNaviSetting: ")
    }

    override fun onNaviMapMode(p0: Int) {
        Log.d(Constants.TAG, "onNaviMapMode: ")
    }

    override fun onNaviTurnClick() {
        Log.d(Constants.TAG, "onNaviTurnClick: ")
    }

    override fun onNextRoadClick() {
        Log.d(Constants.TAG, "onNextRoadClick: ")
    }

    override fun onScanViewButtonClick() {
        Log.d(Constants.TAG, "onScanViewButtonClick: ")
    }

    override fun onLockMap(p0: Boolean) {
        Log.d(Constants.TAG, "onLockMap: ")
    }

    override fun onNaviViewLoaded() {
        Log.d(Constants.TAG, "onNaviViewLoaded: ")
    }

    override fun onMapTypeChanged(p0: Int) {
        Log.d(Constants.TAG, "onMapTypeChanged: ")
    }

    override fun onNaviViewShowMode(p0: Int) {
        Log.d(Constants.TAG, "onNaviViewShowMode: ")
    }


}