
import 'map_navigation_method_channel.dart';
import 'map_navigation_platform_interface.dart';

final MethodChannelMapNavigation _methodChannel =
    MapNavigationPlatform.instance as MethodChannelMapNavigation;

/// 地图通信中心
class MapNavigationController {
  final int mapId;

  MapNavigationController._({required this.mapId}) {
    // _connectStreams(mapId);
  }

  ///根据传入的id初始化[MapNavigationController]
  /// 主要用于在[AMapWidget]初始化时在[AMapWidget.onMapCreated]中初始化controller
  static Future<MapNavigationController> init(int id) async {
    return MapNavigationController._(mapId: id);
  }

  /// 开始定位
  Future<void> startNav(Map? startPoint, Map? endPoint) {
    return _methodChannel.startNav(startPoint, endPoint);
  }
}
