//
//  ClxMapNavigationConvertUtil.m
//  clx_map_navigation
//
//  Created by yjc on 2022/11/30.
//

#import "ClxMapNavigationConvertUtil.h"

@implementation ClxMapNavigationConvertUtil

/// 检测经纬度是否有效
/// @param latitude 维度
/// @param longitude 经度
+ (BOOL)checkValidLatitude:(double)latitude longitude:(double)longitude {
    if (latitude > 90 || latitude < -90) {
        return false;
    }
    if (longitude > 180 || longitude < -180) {
        return  false;
    }
    return true;
}

/// 从数据中解析经纬度
/// @param array 经纬度数组对（默认第一个当做维度，第二个当做经度）
+ (CLLocationCoordinate2D)coordinateFromArray:(NSArray *)array {
    CLLocationCoordinate2D location = kCLLocationCoordinate2DInvalid;
    if (array.count == 2) {
        double latitude = [array[0] doubleValue];
        double longitude = [array[1] doubleValue];
        if ([self checkValidLatitude:latitude longitude:longitude]) {
            location = CLLocationCoordinate2DMake(latitude, longitude);
        } else if ([self checkValidLatitude:longitude longitude:latitude]) {//交换二者
            location = CLLocationCoordinate2DMake(longitude, latitude);
        } else {
            NSLog(@"经纬度参数异常，解析为无效经纬度");
        }
    } else {
        NSLog(@"经纬度参数异常，解析为无效经纬度");
    }
    return location;
}

+ (MAMapRect)mapRectFromArray:(NSArray *)array {
    NSAssert((array && [array isKindOfClass:[NSArray class]] && array.count == 2), @"解析mapRect的参数有误");
    CLLocationCoordinate2D southwest = [ClxMapNavigationConvertUtil coordinateFromArray:array[0]];
    CLLocationCoordinate2D northeast = [ClxMapNavigationConvertUtil coordinateFromArray:array[1]];
    MAMapPoint mapNorthEastPoint = MAMapPointForCoordinate(northeast);
    MAMapPoint mapSouthWestPoint = MAMapPointForCoordinate(southwest);
    double width  = fabs(mapNorthEastPoint.x - mapSouthWestPoint.x);
    double height = fabs(mapNorthEastPoint.y - mapSouthWestPoint.y);
    MAMapRect limitRect = MAMapRectMake(mapSouthWestPoint.x, mapNorthEastPoint.y, width, height);
    return limitRect;
}

@end
