package com.clx.navigation.clx_map_navigation

import android.util.Log
import androidx.annotation.NonNull
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleOwner
import com.amap.api.navi.NaviSetting
import io.flutter.embedding.engine.plugins.FlutterPlugin
import io.flutter.embedding.engine.plugins.FlutterPlugin.FlutterPluginBinding
import io.flutter.embedding.engine.plugins.activity.ActivityAware
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding
import io.flutter.embedding.engine.plugins.lifecycle.HiddenLifecycleReference
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel
import io.flutter.plugin.common.PluginRegistry


/** ClxMapNavigationPlugin */
class ClxMapNavigationPlugin : FlutterPlugin, ActivityAware {

    private var mLifecycle: Lifecycle? = null

    override fun onAttachedToEngine(@NonNull binding: FlutterPluginBinding) {
        Log.d(Constants.TAG, "onAttachedToEngine: ")

        binding.platformViewRegistry
            .registerViewFactory(
                Constants.VIEW_TYPE,
                NavigationPlatformViewFactory(
                    binding.binaryMessenger,
                    object : LifecycleProvider {
                        override val lifecycle: Lifecycle?
                            get() = mLifecycle
                    }
                )
            )
    }

    override fun onDetachedFromEngine(@NonNull binding: FlutterPluginBinding) {
        Log.d(Constants.TAG, "onDetachedFromEngine: ")
    }

    /**=============================ActivityAware===============================*/
    override fun onAttachedToActivity(binding: ActivityPluginBinding) {
        Log.d(Constants.TAG, "onAttachedToActivity: ")
        mLifecycle = (binding.lifecycle as HiddenLifecycleReference).lifecycle
    }

    override fun onDetachedFromActivity() {
        Log.d(Constants.TAG, "onDetachedFromActivity: ")
        mLifecycle = null
    }

    override fun onReattachedToActivityForConfigChanges(binding: ActivityPluginBinding) {
        Log.d(Constants.TAG, "onReattachedToActivityForConfigChanges: ")
        onAttachedToActivity(binding)
    }

    override fun onDetachedFromActivityForConfigChanges() {
        Log.d(Constants.TAG, "onDetachedFromActivityForConfigChanges: ")
        onDetachedFromActivity()
    }

}
