import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:clx_map_navigation/core/clx_map_navigation_method_channel.dart';

void main() {
  MethodChannelClxMapNavigation platform = MethodChannelClxMapNavigation();
  const MethodChannel channel = MethodChannel('clx_map_navigation');

  TestWidgetsFlutterBinding.ensureInitialized();

  setUp(() {
    channel.setMockMethodCallHandler((MethodCall methodCall) async {
      return '42';
    });
  });

  tearDown(() {
    channel.setMockMethodCallHandler(null);
  });

  test('getPlatformVersion', () async {
    expect(await platform.getPlatformVersion(), '42');
  });
}
