import 'package:clx_map_navigation/amap_navigation_widget.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:plugin_platform_interface/plugin_platform_interface.dart';
import 'map_navigation_method_channel.dart';

abstract class MapNavigationPlatform extends PlatformInterface {
  /// Constructs a ClxMapNavigationPlatform.
  MapNavigationPlatform() : super(token: _token);

  static final Object _token = Object();

  static MapNavigationPlatform _instance = MethodChannelMapNavigation();

  /// The default instance of [MapNavigationPlatform] to use.
  ///
  /// Defaults to [MethodChannelClxMapNavigation].
  static MapNavigationPlatform get instance => _instance;
  
  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [MapNavigationPlatform] when
  /// they register themselves.
  static set instance(MapNavigationPlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  // 获取平台版本实例
  Future<void> startNav(Map startPoint, Map endPoint) {
    throw UnimplementedError('platformVersion() has not been implemented.');
  }

  Widget buildMapNavigationView(
      Map<String, dynamic> creationParams,
      Set<Factory<OneSequenceGestureRecognizer>> gestureRecognizers,
      PlatformViewCreatedCallback onPlatformViewCreated,
      MapClosedCallback? onMapClosed,) {
    throw UnimplementedError('buildView() has not been implemented.');
  }

}
