import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:clx_flutter_message/clx_flutter_message_method_channel.dart';

void main() {
  TestWidgetsFlutterBinding.ensureInitialized();

  MethodChannelClxFlutterMessage platform = MethodChannelClxFlutterMessage();
  const MethodChannel channel = MethodChannel('clx_flutter_message');

  setUp(() {
    TestDefaultBinaryMessengerBinding.instance.defaultBinaryMessenger.setMockMethodCallHandler(
      channel,
      (MethodCall methodCall) async {
        return '42';
      },
    );
  });

  tearDown(() {
    TestDefaultBinaryMessengerBinding.instance.defaultBinaryMessenger.setMockMethodCallHandler(channel, null);
  });

  test('getPlatformVersion', () async {
    expect(await platform.getPlatformVersion(), '42');
  });
}
