// 字符串工具类

class StringUtil {
  static bool isEmpty(String? str) {
    return str == null || str.isEmpty;
  }

 static String formatValue(dynamic content, {String defaultValue = '-'}) {
    var value = '';
    if (content == null) {
      value = defaultValue;
    } else if (content is num) {
      value = content.formatIntString();
    } else {
      value = content.toString();
    }
    return value;
  }



}

extension DoubleExten on num? {
  /// 如果是0.0则返回int
  String formatIntString() {
    if (this == null) {
      return '';
    } else if (this is double) {
      var num = this as double;
      return this == num.toInt().toDouble()
          ? num.toInt().toString()
          : toString();
    } else {
      return this?.toString() ?? '';
    }
  }

}
