import 'package:flutter/material.dart';

import '../../../../util/image_widget.dart';
import '../../../model/message_data.dart';

class MessageWidget extends StatelessWidget {
  final MessageData data;
  final double width;
  final void Function() onCancel, onHand;

  const MessageWidget({
    super.key,
    required this.data,
    required this.width,
    required this.onCancel,
    required this.onHand,
  });

  /// 消息能否处理，如果能处理展示去处理按钮，如果不能处理，不展示去处理按钮
  bool get canHand => data.textVo?.data['jumpPageAppUrl'] != null;

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      padding: const EdgeInsets.all(15.0),
      decoration: BoxDecoration(
        color: Colors.black54,
        borderRadius: BorderRadius.circular(8.0),
        boxShadow: const [
          BoxShadow(
            color: Colors.black26,
            offset: Offset(2, 2),
            blurRadius: 5.0,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            children: [
              ImageWidget.loadAssetImage(
                'ic_launcher',
                width: 24,
                height: 24,
                borderRadius: BorderRadius.circular(5),
              ),
              const SizedBox(width: 5),
              Flexible(
                child: Text(
                  data.textVo?.title ?? '',
                  style: const TextStyle(
                    fontSize: 13,
                    color: Colors.white,
                  ),
                ),
              ),
              const SizedBox(width: 5),
              Text(
                ' / ${data.createTime ?? ''}',
                style: TextStyle(
                    color: Colors.white.withAlpha((255 * 0.8).toInt())),
              )
            ],
          ),
          const SizedBox(height: 8),
          Text(
            (data.textVo?.subtitle ?? '-'),
            style: const TextStyle(
              color: Colors.white,
              fontSize: 15,
              fontWeight: FontWeight.w500,
            ),
            overflow: TextOverflow.ellipsis,
          ),
          const SizedBox(height: 8),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              GestureDetector(
                onTap: onCancel,
                child: const Text(
                  '忽略',
                  style: TextStyle(
                    color: Colors.white,
                    fontSize: 14,
                  ),
                ),
              ),
              if (canHand)
                GestureDetector(
                  onTap: onHand,
                  child: const Row(
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      Text(
                        '立即处理',
                        style: TextStyle(
                          color: Colors.white,
                          fontSize: 14,
                        ),
                      ),
                      Icon(
                        Icons.keyboard_double_arrow_right,
                        size: 14,
                        color: Color(0xffC9CDD4),
                      ),
                    ],
                  ),
                ),
            ],
          )
        ],
      ),
    );
  }
}
