
import 'message_data.dart';

/// 消息节点-链表
class MessageNode {
  /// 节点数据
  MessageData data;

  /// 下一个节点
  MessageNode? next;

  /// 上一个节点
  MessageNode? prev;

  MessageNode(this.data);

  /// 插入节点
  void insertData(MessageData data) {
    MessageNode node = MessageNode(data);
    if (this.data.showPriority < data.showPriority) {
      node.next = this;
      node.prev = prev;
      prev?.next = node;
      prev = node;
    } else {
      if (next == null) {
        next = node;
        node.prev = this;
      } else {
        next?.insertData(data);
      }
    }
  }

  /// 移除节点
  void removeData(MessageData data) {
    if (this.data == data) {
      if (next != null) {
        next?.prev = prev;
      }
      if (prev != null) {
        prev?.next = next;
      }
    } else {
      next?.removeData(data);
    }
  }
}
