import 'dart:convert';

/// id : 0
/// messageNo : 0
/// accessKey : ""
/// companyNo : 0
/// userNo : 0
/// messageGroup : ""
/// messageSign : ""
/// showType : ""
/// showPriority : 0
/// validityLimitTime : ""
/// showStatus : 0
/// receivePage : ""
/// jumpPage : ""
/// markdownFlag : 0
/// status : 0
/// statusName : ""
/// textVo : {"title":"","subtitle":"","context":"","dataJson":""}

class MessageData {
  MessageData({
    this.id,
    this.messageNo,
    this.accessKey,
    this.companyNo,
    this.userNo,
    this.messageGroup,
    this.messageSign,
    this.showType,
    num? showPriority,
    this.createTime,
    this.validityLimitTime,
    this.showStatus,
    this.receivePage,
    this.jumpPage,
    this.markdownFlag,
    this.status,
    this.statusName,
    this.textVo,
  }) : _showPriority = showPriority;

  MessageData.fromJson(dynamic json) {
    id = json['id'];
    messageNo = json['messageNo'];
    accessKey = json['accessKey'];
    companyNo = json['companyNo'];
    if (json['userNo'] is String) {
      userNo = json['userNo'];
    } else {
      userNo = json['userNo'].toString();
    }
    messageGroup = json['messageGroup'];
    messageSign = json['messageSign'];
    showType = json['showType'];
    _showPriority = json['showPriority'];
    createTime = json['createTime'];
    validityLimitTime = json['validityLimitTime'];
    showStatus = json['showStatus'];
    receivePage = json['receivePage'];
    jumpPage = json['jumpPage'];
    markdownFlag = json['markdownFlag'];
    status = json['status'];
    statusName = json['statusName'];
    textVo = json['textVo'] != null ? TextVo.fromJson(json['textVo']) : null;
  }

  String? id;
  String? messageNo;
  String? accessKey;
  String? companyNo;
  String? userNo;
  String? messageGroup;
  String? messageSign;

  /// 1: 首页公告（需要处理）。 2: 全局通知（全局弹窗、需要处理）。3：消息提醒（不弹窗、无处理按钮、没有跳转页面）
  String? showType;
  num? _showPriority;

  num get showPriority => _showPriority ?? 0;
  String? createTime;
  String? validityLimitTime;
  num? showStatus;
  String? receivePage;
  String? jumpPage;
  num? markdownFlag;

  /// 消息状态 0未读 10已读 20已执行
  num? status;
  String? statusName;
  TextVo? textVo;

  /// 是否已处理(先把已读标识为已执行)
  bool get isHand => status == 10;

  MessageData copyWith({
    String? id,
    String? messageNo,
    String? accessKey,
    String? companyNo,
    String? userNo,
    String? messageGroup,
    String? messageSign,
    String? showType,
    num? showPriority,
    String? validityLimitTime,
    String? createTime,
    num? showStatus,
    String? receivePage,
    String? jumpPage,
    num? markdownFlag,
    num? status,
    String? statusName,
    TextVo? textVo,
  }) =>
      MessageData(
        id: id ?? this.id,
        messageNo: messageNo ?? this.messageNo,
        accessKey: accessKey ?? this.accessKey,
        companyNo: companyNo ?? this.companyNo,
        userNo: userNo ?? this.userNo,
        messageGroup: messageGroup ?? this.messageGroup,
        messageSign: messageSign ?? this.messageSign,
        showType: showType ?? this.showType,
        showPriority: showPriority ?? _showPriority,
        createTime: createTime ?? this.createTime,
        validityLimitTime: validityLimitTime ?? this.validityLimitTime,
        showStatus: showStatus ?? this.showStatus,
        receivePage: receivePage ?? this.receivePage,
        jumpPage: jumpPage ?? this.jumpPage,
        markdownFlag: markdownFlag ?? this.markdownFlag,
        status: status ?? this.status,
        statusName: statusName ?? this.statusName,
        textVo: textVo ?? this.textVo,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['messageNo'] = messageNo;
    map['accessKey'] = accessKey;
    map['companyNo'] = companyNo;
    map['userNo'] = userNo;
    map['messageGroup'] = messageGroup;
    map['messageSign'] = messageSign;
    map['showType'] = showType;
    map['showPriority'] = _showPriority;
    map['createTime'] = createTime;
    map['validityLimitTime'] = validityLimitTime;
    map['showStatus'] = showStatus;
    map['receivePage'] = receivePage;
    map['jumpPage'] = jumpPage;
    map['markdownFlag'] = markdownFlag;
    map['status'] = status;
    map['statusName'] = statusName;
    if (textVo != null) {
      map['textVo'] = textVo?.toJson();
    }
    return map;
  }
}

/// title : ""
/// subtitle : ""
/// context : ""
/// dataJson : ""

class TextVo {
  TextVo({
    this.title,
    this.subtitle,
    this.content,
    this.dataJson,
  });

  TextVo.fromJson(dynamic json) {
    title = json['title'];
    subtitle = json['subtitle'];
    content = json['content'];
    dataJson = json['dataJson'];
  }

  String? title;
  String? subtitle;
  String? content;
  String? dataJson;
  Map<String, dynamic>? _data;
  Map<String, dynamic> get data {
    if (_data != null) return _data!;
    if (dataJson?.isNotEmpty == true) {
      try {
        _data = jsonDecode(dataJson!);
      } catch (e) {
        _data = {};
      }
    } else {
      _data = {};
    }
    return _data!;
  }

  /// 扩展字段
  List<dynamic> get extraShowInfoList => data['extraShowInfoList'] ?? [];

  TextVo copyWith({
    String? title,
    String? subtitle,
    String? content,
    String? dataJson,
  }) =>
      TextVo(
        title: title ?? this.title,
        subtitle: subtitle ?? this.subtitle,
        content: content ?? this.content,
        dataJson: dataJson ?? this.dataJson,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['title'] = title;
    map['subtitle'] = subtitle;
    map['content'] = content;
    map['dataJson'] = dataJson;
    return map;
  }
}

extension MessageDataExt on MessageData {
  /// 是否可处理
  bool get canHand => showType != null && showType != "3";
}
