import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'clx_flutter_message_method_channel.dart';

abstract class ClxFlutterMessagePlatform extends PlatformInterface {
  /// Constructs a ClxFlutterMessagePlatform.
  ClxFlutterMessagePlatform() : super(token: _token);

  static final Object _token = Object();

  static ClxFlutterMessagePlatform _instance = MethodChannelClxFlutterMessage();

  /// The default instance of [ClxFlutterMessagePlatform] to use.
  ///
  /// Defaults to [MethodChannelClxFlutterMessage].
  static ClxFlutterMessagePlatform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [ClxFlutterMessagePlatform] when
  /// they register themselves.
  static set instance(ClxFlutterMessagePlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  Future<String?> getPlatformVersion() {
    throw UnimplementedError('platformVersion() has not been implemented.');
  }
}
