import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'clx_flutter_message_platform_interface.dart';

/// An implementation of [ClxFlutterMessagePlatform] that uses method channels.
class MethodChannelClxFlutterMessage extends ClxFlutterMessagePlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('clx_flutter_message');

  @override
  Future<String?> getPlatformVersion() async {
    final version = await methodChannel.invokeMethod<String>('getPlatformVersion');
    return version;
  }
}
