import 'package:flutter/cupertino.dart';

import '../model/message_data.dart';
import 'notification_layout/notification_layout_widget.dart';

/// 全局消息展示管理
mixin NotificationManager {
  OverlayEntry? _overlayEntry;

  NotificationLayoutController? notificationLayoutController;

  /// 显示悬浮布局
  void showNotification(BuildContext? context) {
    if (context == null) return;
    if (_overlayEntry != null) return; // 防止重复显示
    if (notificationLayoutController?.headNode == null) {
      return; // 防止没有消息时显示
    }
    _overlayEntry = OverlayEntry(
      builder: (context) => const Positioned(
        top: 0,
        left: 0,
        right: 0,
        child: NotificationLayoutWidget(),
      ),
    );

    Overlay.of(context).insert(_overlayEntry!);
  }

  /// 隐藏悬浮布局
  void hideNotification() {
    _overlayEntry?.remove();
    _overlayEntry = null;
  }

  /// 缓存之前的消息列表
  void setNotification(List<MessageData> data) {
    notificationLayoutController?.setCashMessage(data);
  }

  void insertNotification(MessageData data) {
    notificationLayoutController?.insertNotification(data);
  }

  void clear() {
    notificationLayoutController?.clear();
  }
}
