import 'package:clx_flutter_message/clx_flutter_message.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

import 'message/message_config_impl.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  @override
  Widget build(BuildContext context) {
    return GetMaterialApp(
      home: Scaffold(
        appBar: AppBar(
          title: const Text('Plugin example app'),
        ),
        body: SingleChildScrollView(
          child: Column(
            children: [
              TextButton(
                onPressed: () {
                  // 初始化消息插件配置
                  messageConfig
                    ..accessToken = "e2914fd5543142db87185db50f072c2d"
                    ..productCode = "carrier-driver-app"
                    ..userKey = "1021191558918987845"
                    ..webSocketUrl =
                        "ws://gateway.testclx.cn/common-socket-endpoint/common"
                    ..inAppAccessKey = "CARRIER_INTERNAL_MESSAGE_APP"
                    ..functionKey = "default"
                    ..dio = Dio()
                    ..messageManagement = MessageConfigImpl();
                  messageConfig.messageManagement?.refreshMessage(context);
                },
                child: Text("链接"),
              ),
              TextButton(
                onPressed: () {
                  messageConfig.messageManagement?.close();
                },
                child: Text("断开连接"),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
