import 'package:flutter_test/flutter_test.dart';
import 'package:clx_flutter_message/clx_flutter_message.dart';
import 'package:clx_flutter_message/clx_flutter_message_platform_interface.dart';
import 'package:clx_flutter_message/clx_flutter_message_method_channel.dart';
import 'package:plugin_platform_interface/plugin_platform_interface.dart';

class MockClxFlutterMessagePlatform
    with MockPlatformInterfaceMixin
    implements ClxFlutterMessagePlatform {

  @override
  Future<String?> getPlatformVersion() => Future.value('42');
}

void main() {
  final ClxFlutterMessagePlatform initialPlatform = ClxFlutterMessagePlatform.instance;

  test('$MethodChannelClxFlutterMessage is the default instance', () {
    expect(initialPlatform, isInstanceOf<MethodChannelClxFlutterMessage>());
  });

  test('getPlatformVersion', () async {
    ClxFlutterMessage clxFlutterMessagePlugin = ClxFlutterMessage();
    MockClxFlutterMessagePlatform fakePlatform = MockClxFlutterMessagePlatform();
    ClxFlutterMessagePlatform.instance = fakePlatform;

    expect(await clxFlutterMessagePlugin.getPlatformVersion(), '42');
  });
}
