import 'package:clx_flutter_message/core/api/api.dart';
import '../../clx_flutter_message.dart';

mixin MessageNet {
  final api = Api();

  //获取未处理消息
  Future<List<MessageData>> getUnReadMessage() async {
    var result = await _fetchMessage(2);
    if (result['code'] == 0) {
      var data = result['data']?['records'];
      if (data != null && data is List) {
        return Future(() => data.map((e) => MessageData.fromJson(e)).toList());
      }
    }

    return Future(() => List.empty());
  }

  //获取未处理的公告
  Future<List<MessageData>> getUnReadNotice() async {
    var result = await _fetchMessage(1);
    if (result['code'] == 0) {
      var data = result['data']?['records'];
      if (data != null && data is List) {
        return Future(() => data.map((e) => MessageData.fromJson(e)).toList());
      }
    }

    return Future(() => List.empty());
  }

  // 标记消息为已读
  Future<bool> markReadAction(MessageData? message) async {
    if (message?.status == 10) return Future.value(true);
    var result = await api.requestSync(
        method: Method.put,
        requestUrl: '/message-in-app/message/record/updateRecord',
        queryParameters: {
          'id': message?.id,
          'status': 10,
        });
    return result['code'] == 0;
  }

  // 删除消息
  Future<bool> removeMessageAction(MessageData? message) async {
    var result = await api.requestSync(
        method: Method.put,
        requestUrl: '/message-in-app/message/record/deleteMessage',
        queryParameters: {
          'id': message?.id,
        });
    return result['code'] == 0;
  }

  //忽略消息
  Future<bool> ignoreAction(MessageData? message) {
    return markReadAction(message);
  }

  //标记消息已经展示
  void setMessageShowed(MessageData? message) {
    if (message == null) {
      return;
    }
    api.requestSync(
        method: Method.put,
        requestUrl: '/message-in-app/message/record/updateRecordShow',
        queryParameters: {'id': message.id, 'showStatus': 1});
  }

  Future<dynamic> _fetchMessage(showTypes) async {
    var result = await api.requestSync(
      requestUrl: '/message-in-app/message/record/pageShowMessage',
      method: Method.post,
      data: {
        'pageNum': 1,
        'pageSize': 100,
        'accessKey': messageConfig.inAppAccessKey,
        'showTypes': [showTypes]
      },
    );
    return result;
  }

  // 标记全部已读
  Future<dynamic> confirmCleanMessage()  {
    return api.requestSync(
        method: Method.put,
        requestUrl: '/message-in-app/message/record/updateRecordAllForRead',
        queryParameters: {'accessKey': messageConfig.inAppAccessKey});
  }

  // 获取未读消息数量

  Future<dynamic> getUnReadMessageCount()  {
    return api.requestSync(
        method: Method.get,
        requestUrl: '/message-in-app/message/record/listGroupCount',
        queryParameters: {'accessKey': messageConfig.inAppAccessKey});
  }

  // 按组获取未读消息列表

  Future<dynamic> getUnReadMessageByGroup(
      Map<String, dynamic> params)  {
    return api.requestSync(
      method: Method.post,
      data: params,
      requestUrl: '/message-in-app/message/record/pageMessageRecordOrderTime',
    );
  }
}
