# clx_flutter_message

应用内消息通知插件

## 开始使用

### 添加依赖
在 pubspec.yaml 文件中添加依赖
```yaml
dependencies:
    clx_flutter_message:
      git: https://t.clxkj.cn/openSourceLibrary/clx_flutter_message.git
```

## 使用
    
### 导包

```dart
import 'package:clx_flutter_message/clx_flutter_message.dart';
```
    
### 初始化
**在main方法中配置参数**

```dart
  messageConfig
    ..accessToken = SpUtil.getString(SPKey.userToken) ?? ""
    ..companyNo = getCompanyNo
    ..productCode=productCode
    ..userKey=getUserNo
    ..webSocketUrl=Config.socketAddress
    ..inAppAccessKey = inAppAccessKey
    ..messageManagement = MessageConfigImpl();
```
### 创建MessageConfigImpl类实现 BaseMessageConfig


```dart
class MessageConfigImpl extends BaseMessageConfig {

      @override
  Future<List<MessageData>> getUnReadMessage() {
    // TODO: implement getUnReadMessage
    throw UnimplementedError();
  }

  @override
  Future<List<MessageData>> getUnReadNotice() {
    // TODO: implement getUnReadNotice
    throw UnimplementedError();
  }

  @override
  Future<bool> ignoreAction(MessageData? message) {
    // TODO: implement ignoreAction
    throw UnimplementedError();
  }

  @override
  Future<bool> markReadAction(MessageData? message) {
    // TODO: implement markReadAction
    throw UnimplementedError();
  }

  @override
  void onJumpToMessagePage(String page, arguments) {
    // TODO: implement onJumpToMessagePage
  }

  @override
  Future<bool> removeMessageAction(MessageData? message) {
    // TODO: implement removeMessageAction
    throw UnimplementedError();
  }

  @override
  void setMessageShowed(MessageData? message) {
    // TODO: implement setMessageShowed
  }

}
```


### 配置通知公告widget
```dart
 NoticeDialogWidget(
    decoration: BoxDecoration(
              color: Colors.white,
              image: DecorationImage(
                image: AssetImage(
                  ImageLoader.getPath('notice_bg'),
                ),
                alignment: Alignment.topCenter,
              ),
              borderRadius: BorderRadius.circular(20),
            ),
    buttonColor: colors.red,
    cancelText: "取消"
    confirmText: "确定"        
          )
```
### 调用连接获取消息方法
    
```dart
 messageConfig.messageManagement?.refreshMessage(context);
 ```
### 关闭方法
```dart
 messageConfig.messageManagement?.close();
 ```


    