import 'package:clx_flutter_message/util/string_util.dart';
import 'package:clx_flutter_message/util/toast_util.dart';
import 'package:flutter/material.dart';
import 'clx_flutter_message_platform_interface.dart';
import 'common/constant.dart';
import 'core/api/message_net.dart';
import 'core/model/message_config.dart';
import 'core/model/message_data.dart';
import 'core/notice/notice_dialog_widget.dart';
import 'core/notice/notice_manager.dart';
import 'core/notification/notification_layout/notification_layout_widget.dart';
import 'core/notification/notification_manager.dart';
import 'core/socket/socket_io.dart';
export 'core/model/message_config.dart';
export 'core/model/message_data.dart';
export 'core/notice/notice_dialog_widget.dart';
export 'core/notification/notification_layout/notification_layout_widget.dart';

class ClxFlutterMessage {
  Future<String?> getPlatformVersion() {
    return ClxFlutterMessagePlatform.instance.getPlatformVersion();
  }
}

MessageConfig messageConfig = MessageConfig();

abstract class BaseMessageConfig
    with NotificationManager, NoticeManager, MessageNet {
  //处理消息页面跳转
  Future? onJumpToMessagePage(String page, dynamic arguments);

  //连接websocket 获取及时消息
  Future<void> connectWebSocket(BuildContext context) async {
    String userNo = messageConfig.userKey;
    String url = messageConfig.webSocketUrl;
    String connectId = '${DateTime.now().microsecondsSinceEpoch}-$userNo';

    var params = {
      'connectId': connectId,
      'productCode': messageConfig.productCode,
      'functionKey': messageConfig.functionKey,
      'userKey': userNo,
      'companyKey': messageConfig.companyNo
    };

    var headers = {
      'token': messageConfig.accessToken,
      'product-code': messageConfig.productCode,
    };

    Socket.getInstance().onReceivedMessage = (message) {
      // 处理消息
      _handleMessage(message, context);
    };

    await Socket.getInstance().connect(url, params, headers);
  }

  // 处理socket消息
  void _handleMessage(dynamic data, context) {
    var mBizType = data?['bizType'];
    if (mBizType == bizType) {
      var body = MessageData.fromJson(data?['body']);
      if (body.showType == '1') {
        /// 首页公告
        insertNotice(body);
      } else if (body.showType == '2' &&
          messageConfig.showInAppNotification == 1) {
        /// 全局通知
        insertNotification(body);
        showNotification(context);
      }
    } else {
      debugPrint('未知消息类型');
      debugPrint(data.toString());
    }

    handleMessage(data);
  }

  // 处理长连接消息
  void handleMessage(dynamic data);

  close() async {
    clear();
    clearNoticeDialog();
    return await Socket.getInstance().close();
  }

  // 处理消息跳转对应页面
  Future? gotoDealMessage(MessageData? message) {
    if (message?.canHand != true) {
      return null;
    }
    if (message == null) {
      ToastUtils.showCenter("消息为空");
      return null;
    }
    if (messageConfig.companyNo.isNotEmpty &&
        message.companyNo != messageConfig.companyNo) {
      ToastUtils.showCenter("当前公司和消息不匹配");
      return null;
    }
    if (messageConfig.inAppAccessKey != message.accessKey) {
      ToastUtils.showCenter("当前角色和消息不匹配");
      return null;
    }
    var data = message.textVo?.data;
    if (data == null) {
      ToastUtils.showCenter("消息数据为空");
      return null;
    }
    var page = data['jumpPageAppUrl'];
    if (page == null) {
      ToastUtils.showCenter("消息跳转地址为空");
      return null;
    }
    var arguments = data["jumpPageAppParam"];

    return onJumpToMessagePage(page, arguments);
  }

  // 构造方法
  BaseMessageConfig() {
    notificationLayoutController = NotificationLayoutController();
    noticeDialogWidgetController = NoticeDialogWidgetController();
  }

  // 刷新消息、获取未处理消息，重新连接websocket
  Future<void> refreshMessage(BuildContext context) async {
    // 校验消息相关配置字段
    final validationResult = validateMessageConfig();
    if (validationResult != null) {
      ToastUtils.showCenter(validationResult);
      return;
    }

    connectWebSocket(context);

    List<MessageData> nList = await getUnReadMessage();
    List<MessageData> aList = await getUnReadNotice();

    // 处理消息
    setNotification(nList);
    // 处理公告
    setNotice(aList);
  }

  // 标记全部消息已读
  Future<bool> markAllRead() async {
    var res = await confirmCleanMessage();
    return res['code'] == 0;
  }

  // 获取未读消息数量

  Future<dynamic> getUnReadCount() {
    return getUnReadMessageCount();
  }

  // 校验消息配置字段
  String? validateMessageConfig() {
    if (StringUtil.isEmpty(messageConfig.userKey)) {
      return "userNo不能为空";
    }
    if (StringUtil.isEmpty(messageConfig.accessToken)) {
      return "登录token不能为空";
    }
    if (StringUtil.isEmpty(messageConfig.inAppAccessKey)) {
      return "inAppAccessKey不能为空";
    }
    if (StringUtil.isEmpty(messageConfig.functionKey)) {
      return "functionKey不能为空";
    }

    if (StringUtil.isEmpty(messageConfig.productCode)) {
      return "productCode不能为空";
    }
    if (StringUtil.isEmpty(messageConfig.webSocketUrl)) {
      return "webSocketUrl不能为空";
    }
    return null; // 所有校验通过
  }
}
