import 'dart:io';

import 'package:apk_update/core/services/download_service/download_service.dart';
import 'package:apk_update/utils/dio_update_util.dart';
import 'package:dio/dio.dart';
import 'package:flustars_flutter3/flustars_flutter3.dart';

/// 普通下载
class NormalDownloadImpl implements DownloadService {
  CancelToken? _cancelToken;

  @override
  Future<void> download({
    required String url,
    DownloadProgressCallback? onProgress,
    DownloadSuccessCallback? onSuccess,
    DownloadErrorCallback? onError,
  }) async {
    _cancelToken = CancelToken();
    var localPath = await createDownloadPath();

    try {
      await DioUpdateUtil.dio.download(
        url,
        localPath,
        cancelToken: _cancelToken,
        onReceiveProgress: (int count, int total) {
          if (total != -1) {
            final progress = count / total;
            onProgress?.call(progress);
          }
        },
      );
      onSuccess?.call(localPath);
    } on DioException catch (e) {
      if (e.type != DioExceptionType.cancel) {
        onError?.call(e);
      }
    } catch (e) {
      onError?.call(Exception('下载失败: $e'));
    } finally {
      _cancelToken = null;
    }
  }

  @override
  void cancel() {
    _cancelToken?.cancel('用户取消下载');
    _cancelToken = null;
  }

  /// 创建下载路径
  Future<String> createDownloadPath() async {
    setInitDir(initStorageDir: true);
    await DirectoryUtil.getInstance();
    DirectoryUtil.createStorageDirSync(category: 'Download');
    String path = DirectoryUtil.getStoragePath(
        fileName: 'clx_update', category: 'Download', format: 'apk')!;
    File file = File(path);
    return file.path;
  }
}
