import 'package:flutter/material.dart';

/// 配置类
class AppUpgradeConfig {
  /// 域名
  final String baseUrl;

  /// 一天提示一次升级标识
  final bool onceDay;

  /// token
  final String? token;

  /// 产品编码
  final String? productCode;

  /// appleId
  final String? appleId;

  /// 当前版本code
  final int? versionNumber;

  /// App2.vipApp,3，vip-pc。4，马上富通。5，马上富通pc。6，微信货主。7，货主pc。8，马上审。默认为1
  final int? productNo;

  /// 类型  msl  carrier  pm
  final String? type;

  /// 增加请求头
  final Map<String, dynamic>? headers;

  /// 顶部图片
  final ImageProvider? topImageProvider;

  /// 是否需要请求STS鉴权
  final bool? needSTS;

  @Deprecated(
      '请使用AppUpgradeConfig.msl、AppUpgradeConfig.carrier、msl、AppUpgradeConfig.pm、AppUpgradeConfig.pmOSS代替')
  const AppUpgradeConfig({
    required this.baseUrl,
    this.onceDay = false,
    this.token,
    this.productCode,
    this.appleId,
    this.versionNumber,
    this.productNo,
    this.type,
    this.headers,
    this.topImageProvider,
    this.needSTS = true,
  });

  /// 老马上来(建议走这个配置)
  const AppUpgradeConfig.msl({
    required this.baseUrl,
    required this.productNo,
    this.onceDay = false,
    this.token,
    this.productCode,
    this.appleId,
    this.versionNumber,
    this.headers,
    this.topImageProvider,
    this.needSTS = true,
  }) : type = 'msl';

  /// 承运(建议走这个配置)
  const AppUpgradeConfig.carrier({
    required this.baseUrl,
    this.onceDay = false,
    this.token,
    this.productCode,
    this.appleId,
    this.versionNumber,
    this.headers,
    this.topImageProvider,
    this.needSTS = true,
  })  : type = 'carrier',
        productNo = null;

  /// 项目管理工具(自动配置走OSS还是普通下载，需要Token鉴权)
  const AppUpgradeConfig.pm({
    required this.baseUrl,
    this.onceDay = false,
    this.token,
    this.productCode,
    this.appleId,
    this.versionNumber,
    this.headers,
    this.topImageProvider,
  })  : type = 'pm',
        productNo = null,
        needSTS = true;

  /// 项目管理工具(自动配置走OSS还是普通下载，不需要Token鉴权)
  const AppUpgradeConfig.pmOSS({
    required this.baseUrl,
    this.onceDay = false,
    this.productCode,
    this.appleId,
    this.versionNumber,
    this.headers,
    this.topImageProvider,
  })  : type = 'pm',
        token = '此Token无效,只为了兼容',
        productNo = null,
        needSTS = false;
}
