import 'package:apk_update/apk_update.dart';

import 'impl/carrier_version_impl.dart';
import 'impl/msl_version_impl.dart';
import 'impl/pm_version_impl.dart';
import 'version_service.dart';

/// 版本服务工厂
class VersionServiceFactory {
  static VersionService create(
      {required AppUpgradeConfig config, required String type}) {
    switch (type) {
      case "msl":
        return MSLVersionImpl(config: config);
      case "carrier":
        return CarrierVersionImpl(config: config);
      case "pm":
        return PMVersionImpl(config: config);
      default:
        throw UnsupportedError("暂不支持该平台下发移动端升级");
    }
  }
}
