import 'dart:io';

import 'package:apk_update/core/common/version_info.dart';
import 'package:apk_update/core/services/version_service/version_service.dart';
import 'package:flustars_flutter3/flustars_flutter3.dart';

import '../../../../utils/dio_update_util.dart';
import '../../../../utils/toast_util.dart';
import '../../../common/app_upgrade_config.dart';
import '../../../common/constants.dart';
import '../../../common/servier_api.dart';

/// 项目管理工具
class PMVersionImpl implements VersionService {
  final AppUpgradeConfig config;

  const PMVersionImpl({required this.config});

  @override
  Future<VersionInfo?> checkVersion() async {
    // 获取最新版本
    var result = await getLatestVersionPM();
    if (result == null) return null;
    //获取当前时间
    String spCurrent = SpUtil.getString(Constants.spCurrentDay) ?? "";
    String current =
        DateUtil.formatDate(DateTime.now(), format: Constants.dateFormat);
    //一天只提醒一次：一天提示一次升级标识 & 非强升 & 当天已提示 => 不再提示
    if (config.onceDay &&
        result?['forceUpgradeStatus'] != true &&
        spCurrent == current) {
      // 不再提示
      return null;
    }
    
    var details = result?["detailVo"];

    // 返回升级版本信息
    return VersionInfo(
      name: details['name'],
      content: details['remark'],
      versionForce: result?['forceUpgradeStatus'] == true,
      versionPath: details['versionPath'],
    );
  }

  /// 获取最新版本
  Future<dynamic> getLatestVersionPM() async {
    var result = await DioUpdateUtil.get(
      "${config.baseUrl}${ServerApi.getLatestByProductCodePM}",
      queryParameters: {
        "productCode": config.productCode,
        "currentVersion": config.versionNumber,
        "sideType": Platform.isIOS ? 2 : 1
      },
      headers: {"productGroupCode": "common"},
    );
    if (result == null) return null;
    return result;
  }
}
