import 'package:apk_update/core/common/version_info.dart';
import 'package:apk_update/core/services/version_service/version_service.dart';
import 'package:flustars_flutter3/flustars_flutter3.dart';

import '../../../../utils/dio_update_util.dart';
import '../../../../utils/toast_util.dart';
import '../../../common/app_upgrade_config.dart';
import '../../../common/constants.dart';
import '../../../common/servier_api.dart';

/// 承运
class CarrierVersionImpl implements VersionService {
  final AppUpgradeConfig config;

  const CarrierVersionImpl({required this.config});

  @override
  Future<VersionInfo?> checkVersion() async {
    var result = await DioUpdateUtil.get(
      "${config.baseUrl}${ServerApi.getSystemVersionByNumberCarrier}",
      queryParameters: {
        "versionNumber": config.versionNumber,
        "productCode": config.productCode,
      },
      headers: {"product-code": config.productCode},
    );
    if (result == null) return null;
    //获取当前时间
    String spCurrent = SpUtil.getString(Constants.spCurrentDay) ?? "";
    String current =
        DateUtil.formatDate(DateTime.now(), format: Constants.dateFormat);
    //一天提示一次升级 & 非强升 & 当天已提示 => 不再提示
    if (config.onceDay &&
        result?['versionForce'] == 0 &&
        spCurrent == current) {
      // 不再提示
      return null;
    }
    
    if (result == null) {
      // 无升级任务，拦截
      return null;
    }
    // 返回升级版本信息
    return VersionInfo(
      name: result['versionName'],
      content: result['tipContent'] ?? result['versionContent'],
      versionForce: result['versionForce'] == 1,
      versionPath: result['versionPath'],
    );
  }
}
