import 'package:apk_update/core/services/download_service/impl/normal_download_impl.dart';
import 'package:apk_update/core/services/download_service/impl/oss_download_impl.dart';

import 'download_service.dart';

/// 下载服务工厂
class DownloadServiceFactory {
  static DownloadService create({
    required String baseUrl,
    required String token,
    required String productCode,
  }) {
    if (baseUrl.startsWith("https://gateway.")) {
      // oss
      return OSSDownloadImpl(
          baseUrl: baseUrl, token: token, productCode: productCode);
    } else {
      return NormalDownloadImpl();
    }
  }
}
