import 'package:flutter/material.dart';

/// 配置类
class AppUpgradeConfig {
  /// 域名
  final String baseUrl;

  /// 一天提示一次升级标识
  final bool onceDay;

  /// token
  final String? token;

  /// 产品编码
  final String? productCode;

  /// appleId
  final String? appleId;

  /// 当前版本code
  final int? versionNumber;

  /// App2.vipApp,3，vip-pc。4，马上富通。5，马上富通pc。6，微信货主。7，货主pc。8，马上审。默认为1
  final int? productNo;

  /// 类型  msl  carrier  pm
  final String? type;

  /// 增加请求头
  final Map<String, dynamic>? headers;

  /// 顶部图片
  final ImageProvider? topImageProvider;

  const AppUpgradeConfig({
    required this.baseUrl,
    this.onceDay = false,
    this.token,
    this.productCode,
    this.appleId,
    this.versionNumber,
    this.productNo,
    this.type,
    this.headers,
    this.topImageProvider,
  });
}
