package com.clx.apk_update

import android.content.Context
import android.util.Log
import com.alibaba.sdk.android.oss.ClientException
import com.alibaba.sdk.android.oss.OSSClient
import com.alibaba.sdk.android.oss.ServiceException
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider
import com.alibaba.sdk.android.oss.common.auth.OSSStsTokenCredentialProvider
import com.alibaba.sdk.android.oss.internal.OSSAsyncTask
import com.alibaba.sdk.android.oss.model.ResumableDownloadRequest
import com.alibaba.sdk.android.oss.model.ResumableDownloadResult


object DownloadAppUtil {

    const val TAG = "DownloadAppUtil"

    fun aliDownload(
        context: Context,
        ak: String,
        sk: String,
        token: String,
        endpoint: String,
        bucketName: String,
        objectKey: String,
        localPath: String,
        localFileName: String,
        progressCallback: ProgressCallback
    ) {

        val credentialProvider: OSSCredentialProvider = OSSStsTokenCredentialProvider(ak, sk, token)
        val oss = OSSClient(context, endpoint, credentialProvider)


        // 填写下载到本地文件所在的完整路径。
        val localFile = "$localPath/$localFileName"
        Log.d(TAG, "aliDownload: localFile = $localFile")
        val request = ResumableDownloadRequest(bucketName, objectKey, localFile)

        // 开启断点续传下载功能。
        request.enableCheckPoint = true
        request.checkPointFilePath = localPath
        request.progressListener =
            OSSProgressCallback<Any?> { _, currentSize, totalSize ->
                Log.d(TAG, "aliDownload: currentSize = $currentSize totalSize = $totalSize")
                progressCallback.onProgress(currentSize, totalSize)

            }

        val task: OSSAsyncTask<ResumableDownloadResult> = oss.asyncResumableDownload(
            request,
            object : OSSCompletedCallback<ResumableDownloadRequest?, ResumableDownloadResult?> {
                override fun onSuccess(
                    request: ResumableDownloadRequest?,
                    result: ResumableDownloadResult?
                ) {
                    Log.d(TAG, "onSuccess: $localFile")
                    progressCallback.success(localFile)
                }

                override fun onFailure(
                    request: ResumableDownloadRequest?,
                    clientException: ClientException?,
                    serviceException: ServiceException?
                ) {
                    progressCallback.onFailed()
                    serviceException?.let {
                        Log.e(TAG, "onFailure: ${it.toString()}")
                    }
                    // 请求异常。
                    clientException?.printStackTrace()
                }
            })


        Log.d(TAG, "aliDownload: task.isCompleted = ${task.isCompleted}")


    }


}