import 'dart:io';

import 'package:flustars_flutter3/flustars_flutter3.dart';
import 'package:get/get.dart';
import 'package:url_launcher/url_launcher.dart';

/// 创建下载目录
Future<String?> createDir() async {
  setInitDir(initStorageDir: true);
  await DirectoryUtil.getInstance();
  DirectoryUtil.createStorageDirSync(category: 'Download');
  String? path = DirectoryUtil.getStoragePath(category: 'Download');
  return path;
}

Future<void> deleteFiles(Directory directory, {String suffix = ".apk"}) async {
  if (!await directory.exists()) return;

  await for (var entity in directory.list(recursive: true)) {
    if (entity is File && entity.path.toLowerCase().endsWith(suffix)) {
      await entity.delete();
    }
  }
}

/// 打开浏览器
Future<void> openBrowser(String stringUrl) async {
  final Uri url = Uri.parse(stringUrl);

  if (!await launchUrl(url, mode: LaunchMode.externalApplication)) {
    throw Exception('Could not launch $url');
  }
}

/// 跳转 App Store 详情
void jumpAppStore(String id) async {
  String url = "https://apps.apple.com/cn/app/id$id";

  final uri = Uri.parse(url);
  if (await canLaunchUrl(uri)) {
    await launchUrl(
      uri,
      mode: LaunchMode.externalApplication,
    );
    return;
  }
}

S? findOtherLogic<S>({String? tag}) {
  if (Get.isRegistered<S>(tag: tag)) {
    return Get.find<S>(tag: tag);
  }
  return null;
}