import 'package:apk_update/core/common/app_upgrade_config.dart';
import 'package:apk_update/core/common/version_info.dart';
import 'package:apk_update/core/services/version_service/version_service.dart';
import 'package:flustars_flutter3/flustars_flutter3.dart';

import '../../../../utils/dio_update_util.dart';
import '../../../../utils/toast_util.dart';
import '../../../common/constants.dart';
import '../../../common/servier_api.dart';

/// 老马上来
class MSLVersionImpl implements VersionService {
  final AppUpgradeConfig config;

  const MSLVersionImpl({required this.config});

  @override
  Future<VersionInfo?> checkVersion() async {
    var result = await DioUpdateUtil.get(
      "${config.baseUrl}${ServerApi.getSystemVersionByNumber}",
      queryParameters: {
        "versionNumber": config.versionNumber,
        "productNo": config.productNo
      },
    );
    if (result == null) return null;
    //获取当前时间
    String spCurrent = SpUtil.getString(Constants.spCurrentDay) ?? "";
    String current =
        DateUtil.formatDate(DateTime.now(), format: Constants.dateFormat);
    //一天提示一次升级 & 非强升 & 当天已提示 => 不再提示
    if (config.onceDay &&
        result?['versionForce'] == 0 &&
        spCurrent == current) {
      // 不再提示
      return null;
    }
    //缓存当前时间
    SpUtil.putString(Constants.spCurrentDay, current);
    // 一天提示一次升级，是在应用首次设置，不需要提示最新版本toast
    if (!config.onceDay && result == null) {
      // 当前已经是最新版本
      ToastUtil.showToast("已经是最新版本了！");
      return null;
    }
    if (result == null) {
      // 无升级任务，拦截
      return null;
    }
    // 返回升级版本信息
    return VersionInfo(
      name: result['versionName'],
      content: result['tipContent'] ?? result['versionContent'],
      versionForce: result['versionForce'] == 1,
      versionPath: result['versionPath'],
    );
  }
}
