import 'package:apk_update/app_upgrade_factory.dart';
import 'package:apk_update/core/common/app_upgrade_config.dart';
import 'package:apk_update/utils/image_utils.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  @override
  Widget build(BuildContext context) {
    return GetMaterialApp(
      home: Scaffold(
        appBar: AppBar(
          title: const Text('Plugin example app'),
        ),
        body: Column(
          children: [
            TextButton(
              onPressed: () {
                var appUpgrade = AppUpgradeFactory.create(
                  config: AppUpgradeConfig(
                    baseUrl: "https://api.clxkj.cn:8088",
                    productCode: "",
                    token: "a0b6655571e0412787c9e0dd113ded74",
                    onceDay: false,
                    appleId: "1585610919",
                    versionNumber: 1,
                    productNo: 27,
                  ),
                );

                appUpgrade.checkUpdate();
                // ApkUpdate().checkAppVersion(
                //     baseUrl: "https://api.clxkj.cn:8088",
                //     versionNumber: 1,
                //     productNo: 27,
                //     onceDay: false,
                //     appleId: "1585610919");
              },
              child: const Text('升级应用(旧)'),
            ),
            TextButton(
              onPressed: () {
                var appUpgrade = AppUpgradeFactory.create(
                  config: AppUpgradeConfig(
                    baseUrl: "https://gateway.testclx.cn",
                    productCode: "carrier-driver-app",
                    token: "a0b6655571e0412787c9e0dd113ded74",
                    onceDay: false,
                    appleId: "1585610919",
                    headers: {"product-code": "carrier-driver-app", "model": "TASal00"},
                    versionNumber: 1,
                  ),
                );

                appUpgrade.checkUpdate();

                // var map = {
                //   'token': "20502a804a784bc1a21681e26aa14cb8",
                //   'objectKey': 'msl.apk',
                //   'bucketName': 'mslapp-download',
                //   'endpoint': 'oss-cn-beijing.aliyuncs.com',
                //   "baseUrl": "https://gateway.testclx.cn"
                // };
                // ApkUpdate().updateApp(
                //     url:
                //         "https://gateway.testclx.cn/clx-user/app/version/getSystemVersionByNumber",
                //     params: {
                //       "versionNumber": 1,
                //       "productNo": 1,
                //       "productCode": "carrier-driver-app",
                //     },
                //     onceDay: false,
                //     downloadApkError: () {
                //       ToastUtil.showToast('下载Apk错误');
                //     },
                //     paramsOSS: map,
                //     appleId: "1585610919");
              },
              child: const Text('升级应用(新)'),
            ),
            TextButton(
              onPressed: () {
                var appUpgrade = AppUpgradeFactory.create(
                  config: AppUpgradeConfig(
                    baseUrl: "https://gateway.testclx.cn",
                    productCode: "coal-analysis-report-app",
                    token: "53d33c83e86942fcabe5fe3fbdc4175c",
                    onceDay: false,
                    appleId: "1585610919",
                    headers: {"product-code": "carrier-driver-app", "model": "TASal00"},
                    versionNumber: 1,
                    topImageProvider: ImageUtils.getAssetImage('update_head')
                  ),
                );

                appUpgrade.checkUpdate();

                // var map = {
                //   'token': "a0b6655571e0412787c9e0dd113ded74",
                // };
                // ApkUpdate().updateAppByPM(
                //     baseUrl: "https://gateway.91msl.com",
                //     productCode: "carrier-driver-app",·
                //     versionNumber: 1,
                //     onceDay: false,
                //     paramsOSS: map,
                //     appleId: "1585610919");
              },
              child: const Text('升级应用(项目管理工具)'),
            ),
          ],
        ),
      ),
    );
  }
}
