/// 下载
typedef DownloadProgressCallback = void Function(double progress);
typedef DownloadSuccessCallback = void Function(String filePath);
typedef DownloadErrorCallback = void Function(Exception error);

abstract class DownloadService {
  Future<void> download({
    required String url,
    DownloadProgressCallback? onProgress,
    DownloadSuccessCallback? onSuccess,
    DownloadErrorCallback? onError,
  });

  void cancel();
}
