import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'apk_update_platform_interface.dart';

/// An implementation of [ApkUpdatePlatform] that uses method channels.
class MethodChannelApkUpdate extends ApkUpdatePlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('apk_update');

  @visibleForTesting
  final eventChannel = const EventChannel('download_install_event');

  @override
  void jumpAppStore(String appleId) async {
    methodChannel.invokeMethod<String>('jumpAppStore', {"appleId": appleId});
  }

  @override
  void installApk(String? path) {
    methodChannel.invokeMethod<String>('installApk', {"path": path});
  }

  @override
  void downloadApk(String ak, String sk, String token, String objectKey,
      String endpoint, String bucketName, String localPath, localFileName) {
    methodChannel.invokeMethod<String>('downloadInstall', {
      "ak": ak,
      "sk": sk,
      "token": token,
      "objectKey": objectKey,
      "endpoint": endpoint,
      "bucketName": bucketName,
      "localPath": localPath,
      "localFileName": localFileName,
    });
  }

  @override
  void downloadApkWithoutSTS(
      String ak,
      String sk,
      String objectKey,
      String endpoint,
      String bucketName,
      String localPath,
      String localFileName) {
    methodChannel.invokeMethod<String>('downloadApkWithoutSTS', {
      "ak": ak,
      "sk": sk,
      "objectKey": objectKey,
      "endpoint": endpoint,
      "bucketName": bucketName,
      "localPath": localPath,
      "localFileName": localFileName,
    });
  }

  @override
  Stream<Map<String, Object>> addDownloadListener() {
    return eventChannel
        .receiveBroadcastStream()
        .asBroadcastStream()
        .map<Map<String, Object>>((element) => element.cast<String, Object>());
  }
}
