#import "ApkUpdatePlugin.h"

@implementation ApkUpdatePlugin
+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
    FlutterMethodChannel* channel = [FlutterMethodChannel
                                     methodChannelWithName:@"apk_update"
                                     binaryMessenger:[registrar messenger]];
    ApkUpdatePlugin* instance = [[ApkUpdatePlugin alloc] init];
    [registrar addMethodCallDelegate:instance channel:channel];
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
    //监听退出
    __weak typeof(self) wself = self;
    NSLog(@"ios回调 %@ -- %@", call.method, call.arguments);
    if ([@"jumpAppStore"  isEqualToString:call.method]) {
        NSString *appleId = call.arguments[@"appleId"];
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:[wself goAppStoreUrl: appleId]]];
    } else {
        result(FlutterMethodNotImplemented);
    }
}

- (NSString *)goAppStoreUrl:(NSString *)appleId  {
    return [NSString stringWithFormat:@"https://itunes.apple.com/cn/app/id%@?mt=8", appleId];
}

@end
