import 'package:apk_update/app_upgrade_control.dart';
import 'package:apk_update/core/services/download_service/download_service.dart';
import 'package:apk_update/core/services/download_service/download_service_factory.dart';
import 'package:apk_update/core/services/version_service/version_service_factory.dart';
import 'package:apk_update/utils/dio_update_util.dart';
import 'core/common/app_upgrade_config.dart';
import 'core/services/version_service/version_service.dart';

class AppUpgradeFactory {
  static AppUpgradeControl create({required AppUpgradeConfig config}) {
    assert(config.baseUrl.isNotEmpty, "请传递baseUrl参数");
    assert(config.token != null && config.token!.isNotEmpty, "请传递token参数");
    assert(config.productCode != null, "请传递productCode参数");

    DioUpdateUtil.dio.options.headers = {...config.headers ?? {}};
    // 配置版本服务
    VersionService versionService = VersionServiceFactory.create(
      config: config,
      type: config.type ?? "pm",
    );
    // 配置下载服务
    DownloadService downloadService = config.needSTS == true
        ? DownloadServiceFactory.create(
            baseUrl: config.baseUrl,
            token: config.token ?? '',
            productCode: config.productCode ?? '',
          )
        : DownloadServiceFactory.createWithoutToken(
            baseUrl: config.baseUrl, productCode: config.productCode ?? '');

    return AppUpgradeControl(
      versionService: versionService,
      downloadService: downloadService,
      config: config,
    );
  }
}
