import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'apk_update_method_channel.dart';

abstract class ApkUpdatePlatform extends PlatformInterface {
  /// Constructs a ApkUpdatePlatform.
  ApkUpdatePlatform() : super(token: _token);

  static final Object _token = Object();

  static ApkUpdatePlatform _instance = MethodChannelApkUpdate();

  /// The default instance of [ApkUpdatePlatform] to use.
  ///
  /// Defaults to [MethodChannelApkUpdate].
  static ApkUpdatePlatform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [ApkUpdatePlatform] when
  /// they register themselves.
  static set instance(ApkUpdatePlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  void jumpAppStore(String appleId) {
    throw UnimplementedError('jumpAppStore() has not been implemented.');
  }

  void installApk(String? path) {
    throw UnimplementedError('installApk() has not been implemented.');
  }

  //支持断点下载并安装
  void downloadApk(
      String ak,
      String sk,
      String token,
      String objectKey,
      String endpoint,
      String bucketName,
      String localPath,
      String localFileName) {
    throw UnimplementedError('downloadApk() has not been implemented.');
  }

  // 支持断点下载安装（不通过服务器验证STS）
  void downloadApkWithoutSTS(
      String ak,
      String sk,
      String objectKey,
      String endpoint,
      String bucketName,
      String localPath,
      String localFileName) {
    throw UnimplementedError(
        'downloadApkWithoutSTS() has not been implemented.');
  }

  // 添加下载进度监听
  Stream<Map<String, Object>> addDownloadListener() {
    throw UnimplementedError('addDownloadListener() has not been implemented.');
  }
}
