class InputTipsItem {
  InputTipsItem({
    this.address,
    this.adCode,
    this.district,
    this.name,
    this.latitude,
    this.longitude,
    this.poiID,
    this.typeCode,
  });

  static InputTipsItem fromJson(dynamic json) {
    return InputTipsItem(
      address: json['address'],
      adCode: json['adCode'],
      district: json['district'],
      name: json['name'],
      latitude: json['latitude'],
      longitude: json['longitude'],
      poiID: json['poiID'],
      typeCode: json['typeCode'],
    );
  }

  String? address;
  String? adCode;
  String? district;
  String? name;
  num? latitude;
  num? longitude;
  String? poiID;
  String? typeCode;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['address'] = address;
    map['adCode'] = adCode;
    map['district'] = district;
    map['name'] = name;
    map['latitude'] = latitude;
    map['longitude'] = longitude;
    map['poiID'] = poiID;
    map['typeCode'] = typeCode;
    return map;
  }
}
