import 'package:flutter/services.dart';
import 'package:flutter/src/foundation/basic_types.dart';
import 'package:flutter/src/gestures/recognizer.dart';
import 'package:flutter/src/widgets/framework.dart';
import 'amap_flutter_platform.dart';

/// 使用[MethodChannel]与Native代码通信的[AMapFlutterPlatform]的实现。
class MethodChannelAMapFlutterSearch implements AMapFlutterPlatform {

  late final MethodChannel? _channel;

  MethodChannel searchChannel() {
    return _channel!;
  }

  @override
  Future<void> init(int mapId) {
    MethodChannel? channel = _channel;
    if (channel == null) {
      channel = MethodChannel('amap_flutter_map_search');
      channel.setMethodCallHandler((call) => _handleMethodCall(call));
      _channel = channel;
    }
    return channel.invokeMethod<void>('map#waitForMap');
  }

  Future<dynamic> _handleMethodCall(MethodCall call) async {
    switch (call.method) {
      case 'map#onPoiTouched':
        try {

        } catch (e) {
          print('map#onPoiTouched error===>' + e.toString());
        }
        break;
    }
  }

  // 关键字搜索
  Future<void> keywordsSearch(String keywords) {
    return searchChannel().invokeMethod<dynamic>('camera#searchPOI#keywords', <String, dynamic>{
      'keywords': keywords,
    });
  }

  // 周边搜索
  Future<void> aroundSearch(double latitude, double longitude) {
    return searchChannel().invokeMethod<dynamic>('camera#searchPOI#around', <String, dynamic>{
      'latitude': latitude,
      'longitude': longitude,
    });
  }

  /// 重写的方法
  @override
  Widget buildView(Map<String, dynamic> creationParams,
      Set<Factory<OneSequenceGestureRecognizer>> gestureRecognizers,
      PlatformViewCreatedCallback onPlatformViewCreated) {
    throw UnimplementedError();
  }

  @override
  void dispose({required int id}) {

  }
}
