#import "AMapFlutterMapPlugin.h"
#import "AMapFlutterFactory.h"

@implementation AMapFlutterMapPlugin{
    NSObject<FlutterPluginRegistrar>* _registrar;
    FlutterMethodChannel* _channel;
    NSMutableDictionary* _mapControllers;
}

+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
    AMapFlutterFactory* aMapFactory = [[AMapFlutterFactory alloc] initWithRegistrar:registrar];
    [registrar registerViewFactory:aMapFactory
                            withId:@"com.amap.flutter.map"
  gestureRecognizersBlockingPolicy:
     FlutterPlatformViewGestureRecognizersBlockingPolicyWaitUntilTouchesEnded];
    
    //注册 - MethodChannel
    FlutterMethodChannel *channel = [FlutterMethodChannel methodChannelWithName:@"amap_flutter_map_search"
                                                                binaryMessenger:[registrar messenger]];
    AMapFlutterMapPlugin *instance = [[AMapFlutterMapPlugin alloc] init];
    [registrar addMethodCallDelegate:instance channel:channel];
}

// 使用[MethodChannel]与Native代码通信的[AMapFlutterPlatform]的实现。
- (void)handleMethodCall:(FlutterMethodCall *)call result:(FlutterResult)result {
    NSLog(@"--- AMapFlutterMapPlugin ---: call method -> %@", call.method);
    
    NSDictionary *arguments = call.arguments;
    __weak AMapFlutterMapPlugin *weakSelf = self;
    if ([@"camera#searchPOI#keywords" isEqualToString:call.method]) {
        @try {
            if ([arguments.allKeys containsObject:@"keywords"]) {
                NSString *keywords = arguments[@"keywords"];
                NSLog(@"keywords：%@", keywords);
            }
            result(nil);
        } @catch(FlutterError *e) {
            result(e);
        }
    }
}

@end
