part of amap_flutter_map;

final MethodChannelAMapFlutterSearch _searchMethodChannel = AMapFlutterPlatform.instance as MethodChannelAMapFlutterSearch;

class AMapPoiSearchController {

  /// 单例
  static AMapPoiSearchController instance = AMapPoiSearchController._();
  AMapPoiSearchController._() {
    initPoiSearch();
  }

  /// 初始化方法
  initPoiSearch() async {
    await _searchMethodChannel.init(888);
  }

  void disponse() {
    _searchMethodChannel.dispose(id: 888);
  }

  @visibleForTesting
  MethodChannel get channel {
    return _searchMethodChannel.searchChannel();
  }

  /// poi 搜索
  Future<void> keywordsSearch(String keyWord) {
    return _searchMethodChannel.keywordsSearch(keyWord);
  }

  /// 周边搜索
  Future<void> aroundSearch(double latitude, double longitude) {
    return _searchMethodChannel.aroundSearch(latitude, longitude);
  }

}