import '../../amap_flutter_map.dart';

class InputTipsResult {

  List<InputTipsItem>? inputTipsList;

  InputTipsResult({
    this.inputTipsList,
  });

  InputTipsResult.fromJson(dynamic json) {
    if (json['inputTipsList'] != null) {
      inputTipsList = [];
      json['inputTipsList'].forEach((v) {
        inputTipsList?.add(InputTipsItem.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (inputTipsList != null) {
      map['inputTipsList'] = inputTipsList?.map((v) => v.toJson()).toList();
    }
    return map;
  }

  static InputTipsResult? toInputTipsResult(dynamic json) {
    return InputTipsResult.fromJson(json);
  }

}
