import 'package:amap_flutter_map_example/base_page.dart';
import 'package:amap_flutter_map_example/const_config.dart';
import 'package:flutter/material.dart';
import 'package:amap_flutter_map/amap_flutter_map.dart';

class ShowMapPage extends BasePage {
  ShowMapPage(String title, String subTitle) : super(title, subTitle);

  @override
  Widget build(BuildContext context) {
    return _ShowMapPageBody();
  }
}

class _ShowMapPageBody extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => _ShowMapPageState();
}

class _ShowMapPageState extends State<_ShowMapPageBody> {
  List<Widget> _approvalNumberWidget = <Widget>[];
  var _searchController = TextEditingController();
  List<PoiItem> _poiList = [];
  List<InputTipsItem> _inputTipsList = [];

  @override
  Widget build(BuildContext context) {
    final AMapWidget map = AMapWidget(
      apiKey: ConstConfig.amapApiKeys,
      onMapCreated: onMapCreated,
      onCameraMoveEnd: onCameraMoveEnd,
      onMapSearchPOI: onMapSearchPOI,
      onMapSearchInputTips: onMapSearchInput,
      onMapSearchRegeocode: onMapSearchRegeocode,
    );

    return ConstrainedBox(
      constraints: BoxConstraints.expand(),
      child: Stack(
        children: [
          Container(
            height: MediaQuery.of(context).size.height,
            width: MediaQuery.of(context).size.width,
            child: map,
          ),
          Positioned(
            right: 10,
            bottom: 15,
            child: Container(
              alignment: Alignment.centerLeft,
              child: Column(
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: _approvalNumberWidget),
            ),
          ),
          Positioned(
            child: Container(
              constraints: BoxConstraints(maxHeight: 260.0),
              padding: EdgeInsets.symmetric(horizontal: 20.0),
              color: Color(0xC0FFFFFF),
              child: Column(
                children: [
                  Row(
                    children: [
                      showSelectSearch(),
                      Expanded(
                        child: TextField(
                          controller: _searchController,
                          maxLines: 1,
                          textInputAction: TextInputAction.search,
                          decoration: InputDecoration(
                            hintText: "搜索",
                          ),
                          onSubmitted: (value) {
                            switch (selectedSearch) {
                              case "inputTips":
                                _mapController.searchInput(value);
                                break;
                              default: // "poi"
                                _mapController.searchPoi(value,0);
                            }
                          },
                        ),
                      ),
                    ],
                  ),
                  Expanded(
                    child: ListView.builder(
                      itemCount: selectedSearch == "inputTips"
                          ? _inputTipsList.length
                          : _poiList.length,
                      itemBuilder: (BuildContext context, int index) {
                        return itemWidget(index);
                      },
                    ),
                  ),
                ],
              ),
            ),
          )
        ],
      ),
    );
  }

  late AMapController _mapController;

  void onMapCreated(AMapController controller) {
    setState(() {
      _mapController = controller;
      getApprovalNumber();
    });
  }

  void onCameraMoveEnd(CameraPosition position) {

    print("经纬度: ${position.target.longitude}, ${position.target.latitude}");

    _mapController.searchPoi("",1,latitude: position.target.latitude,longitude: position.target.longitude);
  }


  void onMapSearchPOI(PoiResult poi) {
    _poiList.clear();
    if (poi.poiList != null && poi.poiList!.length > 0) {
      _poiList.addAll(poi.poiList!);
    }
    setState(() {});
  }

  void onMapSearchInput(InputTipsResult tips) {
    _inputTipsList.clear();
    if (tips.inputTipsList != null && tips.inputTipsList!.length > 0) {
      _inputTipsList.addAll(tips.inputTipsList!);
    }
    setState(() {});
  }

  void onMapSearchRegeocode(RegeocodeResult result) {
    print('----- result = ${result.province} ${result.city} ${result.district} ${result.town} ${result.street}  ${result.address}');
  }

  Widget itemWidget(int index) {
    switch (selectedSearch) {
      case "inputTips":
        var data = _inputTipsList[index];
        return InkWell(
          onTap: () {
            _mapController.searchRegeocode(
                data.latitude?.toDouble() ?? 39.963142,
                data.longitude?.toDouble() ?? 116.382644);
          },
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text("${data.district}${data.address}${data.name}"),
              PopupMenuDivider(),
            ],
          ),
        );
      default: // "poi"
        var data = _poiList[index];
        return InkWell(
          onTap: () {
            _mapController.searchRegeocode(
                data.latitude?.toDouble() ?? 39.963142,
                data.longitude?.toDouble() ?? 116.382644);
          },
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                  "${data.provinceName} ${data.cityName} ${data.adName} ${data.snippet} ${data.title}"),
              PopupMenuDivider(),
            ],
          ),
        );
    }
  }

  /// 获取审图号
  void getApprovalNumber() async {
    //普通地图审图号
    String mapContentApprovalNumber =
        (await _mapController.getMapContentApprovalNumber())!;
    //卫星地图审图号
    String satelliteImageApprovalNumber =
        (await _mapController.getSatelliteImageApprovalNumber())!;
    var map = await _mapController.getVisibleRegion();
    print(map); //获取地图可视区域
    setState(() {
      _approvalNumberWidget.add(Text(mapContentApprovalNumber));
      _approvalNumberWidget.add(Text(satelliteImageApprovalNumber));
    });
    print('地图审图号（普通地图）: $mapContentApprovalNumber');
    print('地图审图号（卫星地图): $satelliteImageApprovalNumber');
  }

  var selectedSearch = "poi";

  Widget showSelectSearch() {
    return Row(
      children: [
        Container(
          width: 50.0,
          child: PopupMenuButton<String>(
            iconSize: 0.0,
            child: Text(
              "$selectedSearch",
              textAlign: TextAlign.center,
              style: TextStyle(overflow: TextOverflow.ellipsis),
            ),
            offset: Offset(-50.0, 50.0),
            onSelected: (value) {
              print('----- value = $value');
              selectedSearch = value;
              setState(() {});
            },
            itemBuilder: (context) {
              return <PopupMenuEntry<String>>[
                PopupMenuItem<String>(
                  value: 'poi',
                  child: Text('poi', textAlign: TextAlign.center),
                ),
                PopupMenuDivider(),
                PopupMenuItem<String>(
                  value: 'inputTips',
                  child: Text('inputTips', textAlign: TextAlign.center),
                ),
              ];
            },
          ),
        ),
        Icon(Icons.arrow_drop_down),
      ],
    );
  }
}
