package com.amap.flutter.map.core;

import android.util.Log;

import com.amap.api.services.core.AMapException;
import com.amap.api.services.core.PoiItem;
import com.amap.api.services.geocoder.RegeocodeAddress;
import com.amap.api.services.geocoder.RegeocodeResult;
import com.amap.api.services.help.Tip;
import com.amap.api.services.poisearch.PoiResult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author : shixiaochen
 * @Time : 2022/4/15
 * @Description :
 */
public class Utils {

    /**
     * poi搜索 数据
     *
     * @param poiResult poiResult
     * @param code      响应码
     * @return 返回数据
     */
    public static List<Map<String, Object>> buildSearchResultList(PoiResult poiResult, int code) {
        List<Map<String, Object>> result = new ArrayList<>();
        if (code == AMapException.CODE_AMAP_SUCCESS) {
            ArrayList<PoiItem> list = poiResult.getPois();
            Log.d("TAG", "buildSearchResultList: list = " + list);
            if (list != null) {
                for (PoiItem poiItem : list) {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("latitude", poiItem.getLatLonPoint().getLatitude());
                    map.put("longitude", poiItem.getLatLonPoint().getLongitude());
                    map.put("provinceName", poiItem.getProvinceName());
                    map.put("provinceCode", poiItem.getProvinceCode());
                    map.put("cityName", poiItem.getCityName());
                    map.put("cityCode", poiItem.getCityCode());
                    map.put("adName", poiItem.getAdName());
                    map.put("businessArea", poiItem.getBusinessArea());
                    map.put("snippet", poiItem.getSnippet());
                    map.put("title", poiItem.getTitle());
                    result.add(map);
                }
            }
        }
        return result;
    }

    /**
     * inputTips 数据
     *
     * @param list tips
     * @param code 响应码
     * @return 返回数据
     */
    public static List<Map<String, Object>> buildSearchInputResultList(List<Tip> list, int code) {
        List<Map<String, Object>> result = new ArrayList<>();
        if (code == AMapException.CODE_AMAP_SUCCESS) {
            Log.d("TAG", "buildSearchResultList: list = " + list);
            if (list != null) {
                for (Tip tip : list) {
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("name", tip.getName());
                    map.put("address", tip.getAddress());
                    map.put("adCode", tip.getAdcode());
                    map.put("district", tip.getDistrict());
                    map.put("poiID", tip.getPoiID());
                    map.put("typeCode", tip.getTypeCode());
                    if (tip.getPoint() != null) {
                        map.put("latitude", tip.getPoint().getLatitude());
                        map.put("longitude", tip.getPoint().getLongitude());
                    } else {
                        map.put("latitude", null);
                        map.put("longitude", null);
                    }
                    result.add(map);
                }
            }
        }
        return result;
    }

    /**
     * SearchRegeocode
     *
     * @param regeocode regeocode
     * @param code      响应码
     * @return 返回数据
     */
    public static Map<String, Object> buildSearchRegeocodeResultList(RegeocodeResult regeocode, int code) {
        Map<String, Object> result = new HashMap<>();
        if (code == AMapException.CODE_AMAP_SUCCESS) {
            if (regeocode != null && regeocode.getRegeocodeAddress() != null) {
                RegeocodeAddress address = regeocode.getRegeocodeAddress();
                result.put("province", address.getProvince());
                result.put("city", address.getCity());
                result.put("town", address.getTownship());
                result.put("street", address.getBuilding());
                result.put("district", address.getDistrict());
                result.put("address", address.getFormatAddress());
                result.put("adCode", address.getAdCode());
                result.put("cityCode", address.getCityCode());
                result.put("country", address.getCountry());
                result.put("neighborhood", address.getNeighborhood());
                result.put("townCode", address.getTowncode());
             }
        }
        return result;
    }

}
