class RegeocodeResult {
  String? province;
  String? city;
  String? town;
  String? name;
  String? street;
  String? country;
  String? address;
  String? adCode;
  String? cityCode;
  String? district;
  String? neighborhood;
  String? townCode;
  num? latitude;
  num? longitude;

  RegeocodeResult({
    this.province,
    this.city,
    this.town,
    this.name,
    this.street,
    this.country,
    this.address,
    this.adCode,
    this.cityCode,
    this.district,
    this.neighborhood,
    this.townCode,
    this.latitude,
    this.longitude,
  });

  static RegeocodeResult fromJson(dynamic json) {
    return RegeocodeResult(
      province: json['province'],
      city: json['city'],
      town: json['town'],
      name: json['name'],
      street: json['street'],
      country: json['country'],
      address: json['address'],
      adCode: json['adCode'],
      cityCode: json['cityCode'],
      district: json['district'],
      neighborhood: json['neighborhood'],
      townCode: json['townCode'],
      latitude: json['latitude'],
      longitude: json['longitude'],
    );
  }

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['province'] = province;
    map['city'] = city;
    map['town'] = town;
    map['name'] = name;
    map['street'] = street;
    map['country'] = country;
    map['address'] = address;
    map['adCode'] = adCode;
    map['cityCode'] = cityCode;
    map['district'] = district;
    map['neighborhood'] = neighborhood;
    map['townCode'] = townCode;
    map['latitude'] = latitude;
    map['longitude'] = longitude;
    return map;
  }

  static RegeocodeResult? toRegeocodeResult(dynamic json) {
    return RegeocodeResult.fromJson(json);
  }
}
