group = "com.aliyun.face.aliyun_face_plugin"
version = "1.0"

allprojects {
    repositories {
        google()
        mavenCentral()
    }
}

val newBuildDir: Directory = rootProject.layout.buildDirectory.dir("../../build").get()
rootProject.layout.buildDirectory.value(newBuildDir)

subprojects {
    val newSubprojectBuildDir: Directory = newBuildDir.dir(project.name)
    project.layout.buildDirectory.value(newSubprojectBuildDir)
}
subprojects {
    project.evaluationDependsOn(":app")
}

plugins {
    id("com.android.library")
    id("kotlin-android")
}

android {
    namespace = "com.aliyun.face.aliyun_face_plugin"
    compileSdk = flutter.compileSdkVersion

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }

    kotlinOptions {
        jvmTarget = JavaVersion.VERSION_17.toString()
    }

    defaultConfig {
        minSdk = flutter.minSdkVersion
    }

    dependencies {
        implementation(fileTree(mapOf("dir" to "libs", "include" to listOf("*.jar"))))

        // 实人认证SDK
        implementation(files("libs/aliyun-base-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-facade-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-face-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-faceaudio-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-facelanguage-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-facequality-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-nfc-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-ocr-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-photinus-2.3.25.4.241012105837.aar"))
        implementation(files("libs/aliyun-wishverify-2.3.25.4.241012105837.aar"))
        implementation(files("libs/Android-AliyunFaceGuard-10052.aar"))
        implementation(files("libs/APSecuritySDK-deepSec-7.0.1.20240528.jiagu.aar"))
        // implementation(name: "aliyun-facelanguage-v2.1.2-20221027112723", ext: "aar")
        // implementation(name: "aliyun-ocr-v2.1.2-20221027112723", ext: "aar")
        // implementation(name: "aliyun-photinus-v2.1.2-20221027112723", ext: "aar")
        // implementation(name: "aliyun-wishverify-v2.1.2-20221027112723", ext: "aar")
        // implementation(name: "Android-AliyunFaceGuard-10033", ext: "aar")
        // implementation(name: "APSecuritySDK-DeepSec-7.0.1.20220813.jiagu", ext: "aar")

        // 实人认证三方依赖库
        implementation("com.squareup.okhttp3:okhttp:3.11.0")
        implementation("com.squareup.okio:okio:1.14.0")
        implementation("com.alibaba:fastjson:1.2.83_noneautotype")
        implementation("com.aliyun.dpa:oss-android-sdk:2.9.11")
    }
}



