import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:webview_flutter/webview_flutter.dart';

class VerifyPage extends StatefulWidget {
  final String url;

  const VerifyPage({super.key, required this.url});

  @override
  _VerifyPageState createState() => _VerifyPageState();
}

class _VerifyPageState extends State<VerifyPage> {
  bool isLoading = true;
  late final WebViewController _controller;

  @override
  void initState() {
    _controller = WebViewController();
    _controller.setJavaScriptMode(JavaScriptMode.unrestricted);
    _controller.setNavigationDelegate(NavigationDelegate(onPageFinished: (url) {
      setState(() {
        isLoading = false;
      });
    }));
    _controller.addJavaScriptChannel('H5CallFlutterInterface',
        onMessageReceived: (JavaScriptMessage message) {
      // 在这里处理从 WebView 发送过来的消息
      Navigator.pop(context, message.message);
    });
    _controller.loadRequest(Uri.parse(widget.url));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar('验证'),
      body: Stack(
        children: [
          WebViewWidget(
            controller: _controller,
          ),
          Offstage(
            offstage: !isLoading,
            child: Container(
              width: MediaQuery.of(context).size.width,
              height: MediaQuery.of(context).size.height,
              color: Colors.white,
            ),
          ),
        ],
      ),
    );
  }
}
